from typing import Any, List, Dict
from .base_oracle import BaseOracle


class RuleBasedOracle(BaseOracle):

    def __call__(self, input_str: str, *args: Any, **kwargs: Any) -> Any:
        print(input_str, self.language.in_language(input_str), self.language.context_name)
        return self.language.in_language(input_str)

    def check_conjecture(self, aut, _type=str):
        print("check")
        counterexample = self.language.counterexample(aut, _type)
        return counterexample
